// priority: 50

ServerEvents.recipes(e => {

  e.smelting("minecraft:leather", "minecraft:rotten_flesh") //腐肉烧成皮革

  // 将下界合金装备烧成下界合金碎片
  let 下界合金装备列表 = [
    "minecraft:netherite_helmet",
    "minecraft:netherite_chestplate",
    "minecraft:netherite_leggings",
    "minecraft:netherite_boots",
    "minecraft:netherite_sword",
    "minecraft:netherite_pickaxe",
    "minecraft:netherite_axe",
    "minecraft:netherite_shovel",
    "minecraft:netherite_hoe"
  ];

  // 遍历数组，为每个装备添加高炉配方
  下界合金装备列表.forEach(装备ID => {
    e.blasting("minecraft:netherite_scrap", 装备ID);
  });

  let 无序配方配置 = [
    // 输出物品ID, [输入物品ID列表]
    ["eternisstarrysky:eternis_apple", ["eternisstarrysky:peach"]],                                              // 寰宇苹果
    ["eternisstarrysky:peach", ["eternisstarrysky:eternis_apple"]],                                              // 星野爱桃
    ["youkaishomecoming:sake_bottle", ["minecraft:glass"]],                                                      // 酒瓶
    ["cataclysm:void_lantern_block", ["minecraft:glowstone", "minecraft:crying_obsidian"]],                      // 虚空灯笼块
    ["cataclysm:void_stone", ["minecraft:redstone_block", "minecraft:obsidian"]],                                // 虚空石
    ["cataclysm:void_infused_end_stone_bricks", ["minecraft:end_stone_bricks", "minecraft:redstone"]],           // 虚空末地石砖
    ["enigmaticlegacy:ascension_amulet", ["enigmaticlegacy:enigmatic_amulet", "enigmaticlegacy:cosmic_heart"]],  // 飞升护符
    ["enigmaticlegacy:eldritch_amulet", ["enigmaticlegacy:enigmatic_amulet", "enigmaticlegacy:abyssal_heart"]],  // 轻蔑之约 (或 怪诞护符)
    ["3x minecraft:quartz", ["minecraft:quartz_block"]],                                                         // 石英块到3个石英
    ["3x minecraft:quartz", ["minecraft:smooth_quartz"]],                                                        // 平滑石英块到3个石英
    ["alexsmobs:mosquito_larva", ["minecraft:rotten_flesh", "minecraft:sugar", "minecraft:poisonous_potato"]]    // 绯红孑孓
    // 你可以在这里添加更多无序配方配置
  ];

  无序配方配置.forEach(配置条目 => {
    let 输出物品 = 配置条目[0];
    let 输入物品列表 = 配置条目[1];

    if (Array.isArray(输入物品列表)) {
      e.shapeless(输出物品, 输入物品列表);
    } else {
      e.shapeless(输出物品, [输入物品列表]);
    }
  });

  // 海王恩惠烧海王锭
  e.blasting("aquaculture:neptunium_ingot", "aquaculture:neptunes_bounty");

  // 纯净之心
  e.shaped("enigmaticaddons:pure_heart", // 输出物品
    [
      " A ", // 配方形状
      "CDC",
      "EBE"
    ],
    {
      A: "minecraft:ghast_tear",         // 恶魂之泪
      B: "minecraft:glowstone_dust",     // 萤石粉
      C: "enigmaticaddons:ichor_droplet",// 灵液滴
      D: "enigmaticlegacy:earth_heart",  // 大地之心
      E: "minecraft:glowstone_dust"      // 萤石粉
    }
  )
  
  // 无知祝福卷轴
  e.shaped("enigmaticaddons:cursed_xp_scroll", [
    "ABA",
    "CDC",
    "ABA"
  ], {
    A: "minecraft:experience_bottle",//经验瓶
    B: "enigmaticlegacy:evil_essence",//邪恶精华
    C: "enigmaticaddons:pure_heart",//纯净之心
    D: "enigmaticlegacy:xp_scroll"//经验卷轴
  })

  //魔力之盾
  e.shaped("kubejs:mana_shield", [
    "CBC",
    "BAB",
    "CBC"
  ], {
    A: "enigmaticlegacy:infernal_shield",//烈焰之傲壁垒
    B: "irons_spellbooks:mana_upgrade_orb",//法力值法球
    C: "irons_spellbooks:arcane_rune"//奥术符文
  })
  //大法师至尊平a
  e.shaped("kubejs:mana_damage_glove", [
    "CBC",
    "EAE",
    "CDC"
  ], {
    A: "artifacts:power_glove",//强力手套
    B: "kubejs:harmonious_magical_eye",//魔力之眼
    C: "irons_spellbooks:mana_upgrade_orb",//法力值法球
    D: "bosses_of_mass_destruction:ancient_anima",//古代灵魂
    E: "irons_spellbooks:arcane_rune"//奥术符文
  })

  // 特殊画作 (原血色突袭1)
  e.shaped(Item.of("minecraft:painting").withNBT({
    "display": {
      "Name": "{\"translate\":\"item.tacz.painting.blood_strike_1\"}"
    },
    "EntityTag": {
      "variant": "tacz:blood_strike_1"
    }
  }), [
    "AAA",
    "ABA",
    "AAA"
  ], {
    A: "#forge:rods/wooden",
    B: "#minecraft:wool"
  })

  // 弹药工作台
  e.shaped(Item.of("tacz:workbench_a").withNBT({ "BlockId": "tacz:ammo_workbench" }), [
    "AA",
    "BC"
  ], {
    A: "#forge:ingots/copper",
    B: "#forge:ingots/iron",
    C: "tacz:ammo_box"
  })

  // 枪械改装台
  e.shaped("tacz:gun_smith_table", [
    "AAA",
    "BCB",
    "B B"
  ], {
    A: "#minecraft:logs",
    B: "#forge:ingots/iron",
    C: "minecraft:iron_block"
  })
  // 火药
  e.shapeless(Item.of("minecraft:gunpowder", 3), [
    "minecraft:flint",
    "minecraft:sugar",
    "minecraft:sugar",
    "minecraft:charcoal",
    "minecraft:charcoal",
    "minecraft:charcoal"
  ])

  e.shaped(Item.of("tacz:workbench_c").withNBT({ "BlockId": "tacz:attachment_workbench" }), [
    "ACA",
    "B B",
    "ADA"
  ], {
    A: "#forge:glass",
    B: "#forge:ingots/iron",
    C: "minecraft:redstone_torch",
    D: "minecraft:chest"
  }) // 配件工作台

  e.shaped(Item.of("tacz:workbench_c").withNBT({ "BlockId": "tacz:attachment_workbench" }), [
    "ACA",
    "B B",
    "ADA"
  ], {
    A: "#forge:glass",
    B: "#forge:ingots/iron",
    C: "minecraft:redstone_torch",
    D: "minecraft:chest"
  }) // 配件工作台

  e.shaped(Item.of("tacz:ammo_box", "{Level:2}"), [
    "BAB",
    "B B",
    "BBB"
  ], {
    A: "#forge:gems/diamond",
    B: "#minecraft:planks"
  }) // 钻石弹药箱 (2级)

  e.shaped(Item.of("tacz:ammo_box", "{Level:1}"), [
    "BAB",
    "B B",
    "BBB"
  ], {
    A: "#forge:ingots/gold",
    B: "#minecraft:planks"
  }) // 金弹药箱 (1级)

  e.shaped("tacz:target", [
    "AAA",
    "ABA",
    " C "
  ], {
    A: "#forge:ingots/iron",
    B: "minecraft:redstone",
    C: "#minecraft:planks"
  }) // 靶子

  e.shaped("tacz:ammo_box", [
    "ABA",
    "A A",
    "AAA"
  ], {
    A: "#forge:ingots/iron",
    B: "#minecraft:planks"
  }) // 铁弹药箱 (0级)

  e.shaped("tacz:target_minecart", [
    "A",
    "B"
  ], {
    A: "tacz:target",
    B: "minecraft:minecart"
  }) // 靶子矿车

  e.shaped("tacz:statue", [
    " A ",
    "BCB",
    " C "
  ], {
    A: "minecraft:quartz_slab",
    B: "minecraft:quartz_stairs",
    C: "minecraft:chiseled_quartz_block"
  })

  e.shaped("enigmaticlegacy:berserk_charm", [//血战沙场之证
    "ABA",
    "DCD",
    "EFE"
  ], {
    A: "l2complements:warden_bone_shard",//强化骨片
    B: "l2complements:explosion_shard",//破灭残片
    C: "enigmaticlegacy:twisted_heart",//扭曲之心
    D: "hmag:evil_flame",//邪恶火焰
    E: "l2complements:blackstone_core",//黑石之心
    F: "minecraft:wither_skeleton_skull"//凋灵骷髅头
  })

  e.shaped("enigmaticlegacy:infernal_shield", [//烈焰之傲壁垒
    "AEA",
    "BDB",
    "FCF"
  ], {
    A: "cataclysm:monstrous_horn",//恶兽犄角
    B: "enigmaticlegacy:evil_essence",//邪恶精髓
    C: "enigmaticlegacy:twisted_heart",//扭曲之心
    D: "minecraft:shield",//盾牌
    E: "bosses_of_mass_destruction:blazing_eye",//烈焰之眼
    F: "l2complements:sculkium_ingot"//幽匿锭
  })

  e.shaped("cataclysm:burning_ashes", [//燃尽余烬
    "ABA",
    "BCB",
    "ABA"
  ], {
    A: "minecraft:fire_charge",//火焰弹
    B: "minecraft:clay_ball",//黏土
    C: "enigmaticlegacy:earth_heart" //大地之心
  })

  e.shaped("enigmaticlegacy:etherium_ingot", [//以太合金锭
    "AAA",
    "BBB",
    "CCC"
  ], {
    A: "enigmaticlegacy:etherium_scraps",//以太合金碎片
    B: "minecraft:gold_block",//金块
    C: "minecraft:netherite_scrap" //下界合金碎片
  })

  e.shaped("4x kubejs:d_material", [//D级材料
    " A ",
    "BCB",
    " D "
  ], {
    A: "minecraft:iron_ingot",//铁锭
    B: "minecraft:copper_ingot",//铜锭
    C: "minecraft:flint",//燧石
    D: "minecraft:clay_ball"//粘土
  })

  e.shaped("4x kubejs:c_material", [//C级材料
    " A ",
    "BCB",
    " D "
  ], {
    A: "minecraft:gold_ingot",//金锭
    B: "minecraft:diamond",//钻石
    C: "minecraft:lapis_lazuli",//青金石
    D: "minecraft:redstone"//红石粉
  })

  e.shaped("4x kubejs:b_material", [//B级材料
    " A ",
    "BCB",
    " D "
  ], {
    A: "goety:dark_ingot",//黑暗金属锭
    B: "minecraft:netherite_ingot",//下届合金锭
    C: "twilightforest:knightmetal_ingot",//骑士金属锭
    D: "twilightforest:ironwood_ingot"//铁木锭
  })

  e.shaped("4x kubejs:a_material", [//A级材料
    " A ",
    "BCD",
    " E "
  ], {
    A: "l2complements:totemic_gold_ingot",//生命锭
    B: "enigmaticlegacy:evil_ingot",//极恶锭
    C: "aquamirae:abyssal_amethyst",//深海紫水晶
    D: "twilightforest:fiery_ingot",//炽铁锭
    E: "l2complements:sculkium_ingot"//幽匿锭
  })

  e.shaped("4x kubejs:s_material", [//S级材料
    " A ",
    "BCD",
    " E "
  ], {
    A: "cataclysm:cursium_ingot",//咒魂锭
    // B: "l2complements:shulkerate_ingot",//潜影锭
    B: "cataclysm:ignitium_ingot",//滕炎锭
    C: "enigmaticlegacy:etherium_ingot",//以太锭
    D: "l2complements:poseidite_ingot",//海神锭
    E: "cataclysm:witherite_ingot"//凋灵合金锭
  })

  e.shaped(
    "enigmaticaddons:chaos_elytra", // 混沌之傲
    [
      "AWA",
      "QXQ",
      "DGD"
    ],
    {
      A: "enigmaticlegacy:cosmic_heart",    // 寰宇之心
      Q: "enigmaticlegacy:evil_ingot",      // 极恶锭
      D: "enigmaticlegacy:evil_essence",    // 邪恶精华
      W: "enigmaticlegacy:abyssal_heart",   // 深渊之心
      X: "minecraft:elytra",                // 鞘翅
      G: "enigmaticlegacy:void_pearl"       // 虚空珍珠
    }
  );

  e.shaped(
    Item.of("enigmaticlegacy:enigmatic_elytra").withNBT({ Unbreakable: 1 }), // 壮丽鞘翅，带NBT
    [
      "FDF",
      "EAE",
      "BCB"
    ],
    {
      A: "alexsmobs:tarantula_hawk_elytra",        // 蛛峰鞘翅
      B: "minecraft:dragon_breath",                // 龙息
      C: "enigmaticlegacy:angel_blessing",         // 天使之祝
      D: "l2complements:eternium_ingot",           // 永恒锭
      E: "deeperdarker:reinforced_echo_shard",     // 强化回响碎片
      F: "enigmaticlegacy:astral_dust"             // 星尘
    }
  );

  e.shaped(
    "enigmaticlegacy:cursed_stone", // 邪恶之石
    [
      "AGA",
      "ECE",
      "BDB"
    ],
    {
      C: "enigmaticlegacy:astral_breaker",  // 星辰破碎者
      A: "l2complements:soul_flame",        // 灵魂火焰
      B: "enigmaticlegacy:astral_dust",     // 星尘
      D: "alexsmobs:void_worm_eye",         // 虚空虫眼
      E: "enigmaticlegacy:evil_essence",    // 邪恶精华
      G: "enigmaticlegacy:twisted_heart"    // 扭曲之心
    }
  );

  e.shaped("8x create:brass_ingot", // 黄铜
    [
      "ABA",
      "BCB",
      "ABA"
    ],
    {
      B: "minecraft:copper_ingot",  // 铜锭
      A: "create:zinc_ingot",    // 锌锭
      C: "#minecraft:coals",//煤木碳
    }
  );

  e.shaped("irons_spellbooks:netherite_mage_helmet", // 战斗法师帽子
    [
      "BBB",
      "BAB",
      "   "
    ],
    {
      B: "irons_spellbooks:magic_cloth",  // 奥术布匹
      A: "minecraft:netherite_helmet",    // 下界合金头盔
    }
  );

  e.shaped("irons_spellbooks:netherite_mage_chestplate", // 战斗法师袍
    [
      "BAB",
      "BBB",
      "BBB"
    ],
    {
      B: "irons_spellbooks:magic_cloth",  // 奥术布匹
      A: "minecraft:netherite_chestplate",// 下界合金胸甲
    }
  );

  e.shaped("irons_spellbooks:netherite_mage_leggings", // 战斗法师裤子
    [
      "BBB",
      "BAB",
      "B B"
    ],
    {
      B: "irons_spellbooks:magic_cloth",  // 奥术布匹
      A: "minecraft:netherite_leggings",    // 下界合金护腿
    }
  );

  e.shaped("irons_spellbooks:netherite_mage_boots", // 战斗法师靴子
    [
      "BAB",
      "B B",
      "   "
    ],
    {
      B: "irons_spellbooks:magic_cloth",  // 奥术布匹
      A: "minecraft:netherite_boots",    // 下界合金靴子
    }
  );

  e.shaped("irons_spellbooks:common_ink", // 普通墨水
    [
      "BAB",
      "ACA",
      "BAB"
    ],
    {
      B: "irons_spellbooks:arcane_essence", // 奥术源质
      A: "minecraft:iron_ingot",            // 铁锭
      C: "minecraft:ink_sac",               // 墨囊
    }
  );

  e.shaped("irons_spellbooks:uncommon_ink", // 卓越墨水
    [
      "BAB",
      "ACA",
      "BAB"
    ],
    {
      B: "irons_spellbooks:arcane_essence", // 奥术源质
      A: "minecraft:gold_ingot",            // 金锭
      C: "irons_spellbooks:common_ink",     // 普通墨水
    }
  );

  e.shaped("irons_spellbooks:rare_ink", // 高级墨水
    [
      "BAB",
      "ACA",
      "BAB"
    ],
    {
      B: "goety:magic_emerald",             // 觉醒绿宝石
      A: "irons_spellbooks:arcane_ingot",   // 奥术锭
      C: "irons_spellbooks:uncommon_ink",   // 卓越墨水
    }
  );

  e.shaped("2x irons_spellbooks:epic_ink", // 史诗墨水
    [
      "AGA",
      "ECE",
      "BDB"
    ],
    {
      G: "minecraft:diamond",               // 钻石
      E: "irons_spellbooks:arcane_ingot",   // 奥术锭
      C: "irons_spellbooks:rare_ink",       // 高级墨水
      B: "minecraft:netherite_ingot",       // 下界合金
      D: "minecraft:nether_star",           // 下界之星
      A: "minecraft:amethyst_shard"         // 紫水晶碎片
    }
  );

  e.shaped("2x irons_spellbooks:legendary_ink", // 传说墨水
    [
      "AGA",
      "ECB",
      "HDH"
    ],
    {
      G: "irons_spellbooks:blood_vial",     // 猩红精华
      E: "enigmaticaddons:ichor_droplet",   // 灵液滴
      C: "irons_spellbooks:epic_ink",       // 史诗墨水
      B: "l2complements:life_essence",      // 生命精华
      D: "deeperdarker:heart_of_the_deep",  // 监守者之心
      A: "minecraft:amethyst_cluster",      // 紫水晶簇
      H: "goety:dark_ingot"                 //黑暗金属锭
    }
  );

  e.shaped("irons_spellbooks:blank_rune", // 空白符文
    [
      "BBB",
      "BAB",
      "BBB"
    ],
    {
      B: "minecraft:stone",                 // 石头
      A: "irons_spellbooks:arcane_ingot",   // 奥术锭
    }
  );

  e.shaped("2x irons_spellbooks:cinder_essence", // 灰烬源质
    [
      "BBB",
      "BAB",
      "BBB"
    ],
    {
      B: "irons_spellbooks:arcane_essence", // 奥术源质
      A: "irons_spellbooks:cinder_essence", // 灰烬源质
    }
  );

  e.shaped("cataclysm:cursium_upgrade_smithing_template", // 咒魂模板
    [
      "BCB",
      "BAB",
      "BCB"
    ],
    {
      B: "cataclysm:ancient_metal_ingot", // 远古金属锭
      A: "l2complements:soul_flame", // 灵魂火种
      C: "l2complements:sculkium_ingot"//幽匿锭
    }
  );

  e.shaped("bosses_of_mass_destruction:mob_ward", [//镇压之杖
    "BAB",
    " D ",
    " C "
  ], {
    A: "minecraft:amethyst_shard",//紫水晶碎片
    B: "minecraft:glowstone_dust",//萤石粉
    C: "minecraft:gold_block",//金块
    D: "minecraft:obsidian",//黑曜石
  })

  //幽匿头盔
  e.smithing(
    // 输出物品：幽匿头盔
    "l2complements:sculkium_helmet",
    //锻造模板：咒魂模板
    "cataclysm:cursium_upgrade_smithing_template",
    // 输入物品：监守者头盔 (这里我修正了原文的靴子，应该是头盔)
    "deeperdarker:warden_helmet",
    // 添加材料：咒魂锭
    "cataclysm:cursium_ingot"
  )

  //幽匿胸甲
  e.smithing(
    // 输出物品：幽匿胸甲
    "l2complements:sculkium_chestplate",
    //锻造模板：咒魂模板
    "cataclysm:cursium_upgrade_smithing_template",
    // 输入物品：监守者胸甲
    "deeperdarker:warden_chestplate",
    // 添加材料：咒魂锭
    "cataclysm:cursium_ingot"
  )

  //幽匿护腿
  e.smithing(
    // 输出物品：幽匿护腿
    "l2complements:sculkium_leggings",
    //锻造模板：咒魂模板
    "cataclysm:cursium_upgrade_smithing_template",
    // 输入物品：监守者护腿
    "deeperdarker:warden_leggings",
    // 添加材料：咒魂锭
    "cataclysm:cursium_ingot"
  )

  //幽匿靴子
  e.smithing(
    // 输出物品：幽匿靴子
    "l2complements:sculkium_boots",
    //锻造模板：咒魂模板
    "cataclysm:cursium_upgrade_smithing_template",
    // 输入物品：监守者靴子
    "deeperdarker:warden_boots",
    // 添加材料：咒魂锭
    "cataclysm:cursium_ingot"
  )

  //滕炎头盔
  e.smithing(
    // 输出物品：滕炎头盔
    "cataclysm:ignitium_helmet",
    //锻造模板：滕炎锻造模板
    "cataclysm:ignitium_upgrade_smithing_template",
    // 输入物品：战斗法师帽子
    "irons_spellbooks:netherite_mage_helmet",
    // 添加材料：滕炎锭
    "cataclysm:ignitium_ingot"
  )

  //滕炎胸甲
  e.smithing(
    // 输出物品：滕炎胸甲
    "cataclysm:ignitium_chestplate",
    //锻造模板：滕炎锻造模板
    "cataclysm:ignitium_upgrade_smithing_template",
    // 输入物品：战斗法师袍
    "irons_spellbooks:netherite_mage_chestplate",
    // 添加材料：滕炎锭
    "cataclysm:ignitium_ingot"
  )

  //滕炎裤子
  e.smithing(
    // 输出物品：滕炎裤子
    "cataclysm:ignitium_leggings",
    //锻造模板：滕炎锻造模板
    "cataclysm:ignitium_upgrade_smithing_template",
    // 输入物品：战斗法师裤子
    "irons_spellbooks:netherite_mage_leggings",
    // 添加材料：滕炎锭
    "cataclysm:ignitium_ingot"
  )

  //滕炎靴子
  e.smithing(
    // 输出物品：滕炎靴子
    "cataclysm:ignitium_boots",
    //锻造模板：滕炎锻造模板
    "cataclysm:ignitium_upgrade_smithing_template",
    // 输入物品：战斗法师靴子
    "irons_spellbooks:netherite_mage_boots",
    // 添加材料：滕炎锭
    "cataclysm:ignitium_ingot"
  )

  // 共鸣石剑
  e.smithing(
    "deeperdarker:resonarium_sword",                    // 输出物品
    "hmag:evil_crystal_upgrade_smithing_template",      // 锻造模板
    "minecraft:iron_sword",                             // 输入物品 
    "deeperdarker:resonarium_plate", // 添加材料
  );

  // 共鸣石镐
  e.smithing(
    "deeperdarker:resonarium_pickaxe",
    "hmag:evil_crystal_upgrade_smithing_template",
    "minecraft:iron_pickaxe",
    "deeperdarker:resonarium_plate",
  );

  // 共鸣石斧
  e.smithing(
    "deeperdarker:resonarium_axe",
    "hmag:evil_crystal_upgrade_smithing_template",
    "minecraft:iron_axe",
    "deeperdarker:resonarium_plate",
  );

  // 共鸣石锹
  e.smithing(
    "deeperdarker:resonarium_shovel",
    "hmag:evil_crystal_upgrade_smithing_template",
    "minecraft:iron_shovel",
    "deeperdarker:resonarium_plate",
  );

  // 共鸣石锄
  e.smithing(
    "deeperdarker:resonarium_hoe",
    "hmag:evil_crystal_upgrade_smithing_template",
    "minecraft:iron_hoe",
    "deeperdarker:resonarium_plate",
  );

  // 共鸣石头盔
  e.smithing(
    "deeperdarker:resonarium_helmet",
    "hmag:evil_crystal_upgrade_smithing_template",
    "minecraft:iron_helmet",
    "deeperdarker:resonarium_plate",
  );

  // 共鸣石胸甲
  e.smithing(
    "deeperdarker:resonarium_chestplate",
    "hmag:evil_crystal_upgrade_smithing_template",
    "minecraft:iron_chestplate",
    "deeperdarker:resonarium_plate",
  );

  // 共鸣石护腿
  e.smithing(
    "deeperdarker:resonarium_leggings",
    "hmag:evil_crystal_upgrade_smithing_template",
    "minecraft:iron_leggings",
    "deeperdarker:resonarium_plate",
  );

  // 共鸣石靴子
  e.smithing(
    "deeperdarker:resonarium_boots",
    "hmag:evil_crystal_upgrade_smithing_template",
    "minecraft:iron_boots",
    "deeperdarker:resonarium_plate",
  );

  // 流浪兜帽
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "minecraft:golden_helmet" //激活仪式(中心物品)所需的物品为 "金头盔"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
      ],
      "result": { // 仪式制作结果
        "item": "irons_spellbooks:wandering_magician_helmet", // 流浪兜帽
      }
    }
  );

  // 流浪法袍
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "minecraft:golden_chestplate" //激活仪式(中心物品)所需的物品为 "金胸甲"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
      ],
      "result": { // 仪式制作结果
        "item": "irons_spellbooks:wandering_magician_chestplate", // 流浪法袍
      }
    }
  );

  // 流浪裤子
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "minecraft:golden_leggings" //激活仪式(中心物品)所需的物品为 "金护腿"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
      ],
      "result": { // 仪式制作结果
        "item": "irons_spellbooks:wandering_magician_leggings", // 流浪裤子
      }
    }
  );

  // 流浪靴子
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "minecraft:golden_boots" //激活仪式(中心物品)所需的物品为 "金靴子"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:arcane_ingot" // 奥术锭
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
      ],
      "result": { // 仪式制作结果
        "item": "irons_spellbooks:wandering_magician_boots", // 流浪靴子
      }
    }
  );

  // 远古头盔
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "irons_spellbooks:wandering_magician_helmet" //激活仪式(中心物品)所需的物品为 "流浪兜帽"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "hmag:ancient_stone_block" // 远古晶石块
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
      ],
      "result": { // 仪式制作结果
        "item": "hmag:ancient_helmet", // 远古头盔
      }
    }
  );

  // 远古胸甲
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "irons_spellbooks:wandering_magician_chestplate" //激活仪式(中心物品)所需的物品为 "流浪法袍"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "hmag:ancient_stone_block" // 远古晶石块
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
      ],
      "result": { // 仪式制作结果
        "item": "hmag:ancient_chestplate", // 远古胸甲
      }
    }
  );

  // 远古护腿
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "irons_spellbooks:wandering_magician_leggings" //激活仪式(中心物品)所需的物品为 "流浪裤子"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "hmag:ancient_stone_block" // 远古晶石块
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
      ],
      "result": { // 仪式制作结果
        "item": "hmag:ancient_leggings", // 远古护腿
      }
    }
  );

  // 远古靴子
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "irons_spellbooks:wandering_magician_boots" //激活仪式(中心物品)所需的物品为 "流浪靴子"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "hmag:ancient_stone_block" // 远古晶石块
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:arcane_salvage" // 奥术残骸
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
        {
          "item": "irons_spellbooks:magic_cloth" // 奥术布匹
        },
      ],
      "result": { // 仪式制作结果
        "item": "hmag:ancient_boots", // 远古靴子
      }
    }
  );

  // 黑暗头盔
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "hmag:ancient_helmet" //激活仪式(中心物品)所需的物品为 "远古头盔"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:spirit_fabric" // 精神布匹
        },
        {
          "item": "goety:soul_ruby" // 灵魂红宝石
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
      ],
      "result": { // 仪式制作结果
        "item": "goety:dark_helmet", // 黑暗头盔
      }
    }
  );

  // 黑暗胸甲
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "hmag:ancient_chestplate" //激活仪式(中心物品)所需的物品为 "远古胸甲"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:spirit_fabric" // 精神布匹
        },
        {
          "item": "goety:spirit_fabric" // 精神布匹
        },
        {
          "item": "goety:soul_ruby" // 灵魂红宝石
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
      ],
      "result": { // 仪式制作结果
        "item": "goety:dark_chestplate", // 黑暗胸甲
      }
    }
  );

  // 黑暗护腿
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "hmag:ancient_leggings" //激活仪式(中心物品)所需的物品为 "远古护腿"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:spirit_fabric" // 精神布匹
        },
        {
          "item": "goety:spirit_fabric" // 精神布匹
        },
        {
          "item": "goety:soul_ruby" // 灵魂红宝石
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
      ],
      "result": { // 仪式制作结果
        "item": "goety:dark_leggings", // 黑暗护腿
      }
    }
  );

  // 黑暗靴子
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "hmag:ancient_boots", //激活仪式(中心物品)所需的物品为 "远古靴子"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 100, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:spirit_fabric" // 精神布匹
        },
        {
          "item": "goety:soul_ruby" // 灵魂红宝石
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
      ],
      "result": { // 仪式制作结果
        "item": "goety:dark_boots", // 黑暗靴子
      }
    }
  );

  // 腐化聚晶
  e.custom(
    {
      // 设置配方类型为 "祭坛"
      "type": "goety:ritual",
      // 设置仪式类型为 死灵仪式
      "ritual_type": "goety:craft",
      // 设置激活仪式所需的物品
      "activation_item": {
        "item": "goety:heart_of_the_night" // 激活仪式(中心物品)所需的物品为 "暗夜之心"
      },
      // 设置仪式制作的物品类型
      "craftType": "necroturgy", // 仪式类型为 大师死灵
      "research": "forbidden", //需要研究(阅读)禁书卷轴
      // 设置仪式所需灵魂点数
      "soulCost": 10000, // 此仪式每秒需要 10000 个灵魂点数
      // 设置仪式持续时间
      "duration": 10, // 此仪式持续 10 秒
      // 设置仪式所需的材料
      "ingredients": [
        {
          "item": "goety:dark_metal_block" // 黑暗金属块
        },
        {
          "item": "goety:ominous_orb" // 凶兆魔球
        },
        {
          "item": "minecraft:nether_star" // 下界之星
        },
        {
          "item": "cataclysm:tidal_claws" // 潮汐之爪
        },
        {
          "item": "cataclysm:ignitium_ingot" // 腾炎锭
        },
        {
          "item": "irons_spellbooks:dragonskin" // 龙鳞
        },
        {
          "item": "alexsmobs:void_worm_eye" // 虚空蠕虫之眼
        },
        {
          "item": "mowziesmobs:wrought_helmet" // 精炼头盔
        }
      ],
      // 仪式制作结果
      "result": {
        "item": "goety:corruption_focus" // 制作 腐化聚晶
      }
    });

  // 永恒锭
  e.custom(
    {
      // 设置配方类型为 "祭坛"
      "type": "goety:ritual",
      // 设置仪式类型为 死灵仪式
      "ritual_type": "goety:craft",
      // 设置激活仪式所需的物品
      "activation_item": {
        "item": "aquamirae:ship_graveyard_echo" // 激活仪式(中心物品)所需的物品为 "海船墓地之回响"
      },
      // 设置仪式制作的物品类型
      "craftType": "forge", // 仪式类型为 大师死灵
      "research": "forbidden", //需要研究(阅读)禁书卷轴
      // 设置仪式所需灵魂点数
      "soulCost": 1000, // 此仪式每秒需要 1000 个灵魂点数
      "duration": 10, // 此仪式持续 10 秒
      // 设置仪式所需的材料
      "ingredients": [
        {
          "item": "enigmaticlegacy:evil_ingot" // 极恶锭
        },
        {
          "item": "twilightforest:fiery_ingot" // 炽铁锭
        },
        {
          "item": "minecraft:nether_star" // 下界之星
        },
        {
          "item": "l2complements:shulkerate_ingot" // 潜影锭
        },
        {
          "item": "cataclysm:ignitium_ingot" // 腾炎锭
        },
        {
          "item": "enigmaticlegacy:etherium_ingot" // 以太锭
        },
        {
          "item": "goety:dark_ingot" // 黑暗金属锭
        },
        {
          "item": "l2complements:poseidite_ingot" // 海神锭
        }
      ],
      // 仪式制作结果
      "result": {
        "item": "l2complements:eternium_ingot" // 制作 永恒锭
      }
    });

  // 千咒卷轴
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "enigmaticlegacy:darkest_scroll" //激活仪式(中心物品)所需的物品为 "至暗卷轴"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 10, // 仪式每秒消耗的灵魂点数
      "duration": 15, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "l2complements:resonant_feather" // 共振之羽
        },
        {
          "item": "enigmaticlegacy:evil_essence" // 邪恶精髓
        },
        {
          "item": "l2complements:hard_ice" // 告死寒霜
        },
        {
          "item": "l2complements:storm_core" // 烈空结晶
        },
        {
          "item": "minecraft:ancient_debris" // 远古残骸
        },
        {
          "item": "l2complements:soul_flame" // 灵魂火种
        },
        {
          "item": "l2complements:captured_wind" // 千风精华
        },
        {
          "item": "enigmaticlegacy:twisted_heart" // 扭曲之心
        }
      ],
      "result": { // 仪式制作结果
        "item": "enigmaticlegacy:cursed_scroll" // 千咒卷轴
      }
    }
  );

  // 非欧立方
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "goety:night_beacon" //激活仪式(中心物品)所需的物品为 "暗夜信标"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 10, // 仪式每秒消耗的灵魂点数
      "duration": 15, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "enigmaticlegacy:ocean_stone" // 海洋意志
        },
        {
          "item": "enigmaticlegacy:angel_blessing" // 天使之祝
        },
        {
          "item": "enigmaticlegacy:void_pearl" // 虚空术石
        },
        {
          "item": "enigmaticlegacy:golem_heart" // 魔像之心
        },
        {
          "item": "enigmaticlegacy:blazing_core" // 烈焰之核
        },
        {
          "item": "enigmaticlegacy:eye_of_nebula" // 星云之眼
        }
      ],
      "result": { // 仪式制作结果
        "item": "enigmaticlegacy:the_cube" // 非欧立方
      }
    }
  );

  // 幽匿护腿
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "l2complements:sculkium_boots" //激活仪式(中心物品)所需的物品为 "幽匿靴子"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 2000, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "l2complements:eternium_ingot" // 永恒锭
        },
        {
          "item": "l2complements:eternium_ingot" // 永恒锭
        },
        {
          "item": "l2complements:eternium_ingot" // 永恒锭
        },
        {
          "item": "l2complements:eternium_ingot" // 永恒锭
        }
      ],
      "result": { // 仪式制作结果
        "item": "l2complements:eternium_boots", // 永恒靴子
      }
    }
  );

  //壁垒聚晶
  e.custom(
    {
      "type": "goety:ritual", // 仪式类型
      "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
      "activation_item": { // 激活仪式所需的物品
        "item": "goety:empty_focus" //激活仪式(中心物品)所需的物品为 "空法术聚晶"
      },
      "craftType": "magic", // 制作类型，此处为魔法
      "soulCost": 2000, // 仪式每秒消耗的灵魂点数
      "duration": 5, // 仪式持续时间，单位为刻度（tick）
      "ingredients": [ // 仪式所需材料
        {
          "item": "enigmaticlegacy:infernal_shield" // 烈焰之傲壁垒
        },
        {
          "item": "twilightforest:fortification_scepter"// 护盾权杖
        },
        {
          "item": "goety:mystic_core" // 神秘核心
        },
        {
          "item": "minecraft:enchanted_golden_apple"// 附魔金苹果
        }
      ],
      "result": { // 仪式制作结果
        "item": "goety:bulwark_focus", //壁垒聚晶
      }
    }
  );

  // 使用魔法仪式合成 硬化 附魔书
  e.custom({
    "type": "goety:ritual", // 仪式类型
    "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
    "activation_item": { // 激活仪式所需的物品 (中心物品)
      "item": "minecraft:book"// 使用书作为激活物品
    },
    "craftType": "magic", // 制作类型，此处为魔法
    "soulCost": 50, // 仪式每秒消耗的灵魂点数 (示例值)
    "duration": 4, // 仪式持续时间，单位为刻度 (tick) (示例值，200 ticks = 10 秒)
    "ingredients": [ // 仪式所需材料 (围绕中心物品摆放)
      {
        "item": "minecraft:diamond"//钻石
      },
      {
        "item": "minecraft:iron_block"//铁块
      },
      {
        "item": "minecraft:obsidian"//黑曜石
      },
      {
        "item": "minecraft:obsidian"//黑曜石
      },
      {
        "item": "minecraft:obsidian"//黑曜石
      },
      {
        "item": "minecraft:obsidian"//黑曜石
      },
      {
        "item": "minecraft:iron_block"//铁块
      },
    ],
    "result": { // 仪式制作结果
      "item": "minecraft:enchanted_book",
      "nbt": { // 指定结果附魔书的附魔
        "StoredEnchantments": [
          {
            "id": "l2complements:hardened",
            "lvl": 1 // 硬化
          }
        ]
      }
    }
  });

  // 使用魔法仪式合成 保护V 附魔书
  e.custom({
    "type": "goety:ritual", // 仪式类型
    "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
    "activation_item": { // 激活仪式所需的物品 (中心物品)
      "item": "minecraft:iron_block"// 使用铁块作为激活物品
    },
    "craftType": "magic", // 制作类型，此处为魔法
    "soulCost": 100, // 仪式每秒消耗的灵魂点数 (示例值)
    "duration": 4, // 仪式持续时间，单位为刻度 (tick) (示例值，原为200, 4 tick非常快)
    "ingredients": [ // 仪式所需材料 (围绕中心物品摆放)
      {
        "item": "minecraft:diamond"// 钻石
      },
      {
        "item": "twilightforest:naga_scale" // 娜迦鳞片
      },
      {
        "item": "twilightforest:naga_scale" // 娜迦鳞片
      }
    ],
    "result": { // 仪式制作结果
      "item": "minecraft:enchanted_book",
      "nbt": { // 指定结果附魔书的附魔
        "StoredEnchantments": [
          {
            "id": "minecraft:protection",
            "lvl": 5 // 保护 V
          }
        ]
      }
    }
  });

  // 使用魔法仪式合成保护6
  e.custom({
    "type": "goety:ritual", // 仪式类型
    "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
    "activation_item": { // 激活仪式所需的物品 (中心物品)
      "item": "deeperdarker:heart_of_the_deep"// 使用海船墓地之回响作为激活物品
    },
    "craftType": "magic", // 制作类型，此处为魔法
    "soulCost": 200, // 仪式每秒消耗的灵魂点数 (示例值)
    "duration": 4, // 仪式持续时间，单位为刻度 (tick) (示例值，200 ticks = 10 秒)
    "ingredients": [ // 仪式所需材料 (围绕中心物品摆放)
      {
        "item": "twilightforest:alpha_yeti_fur"// 雪怪皮毛
      },
      {
        "item": "twilightforest:alpha_yeti_fur"// 雪怪皮毛
      },
      {
        "item": "twilightforest:alpha_yeti_fur"// 雪怪皮毛
      },
      {
        "item": "twilightforest:carminite"// 申铅铁
      },
      {
        "item": "twilightforest:carminite"// 申铅铁
      },
      {
        "item": "minecraft:netherite_ingot" // 下届合金锭
      },
      {
        "item": "minecraft:nether_star" // 下界之星
      }
    ],
    "result": { // 仪式制作结果
      "item": "minecraft:enchanted_book",
      "nbt": { // 指定结果附魔书的附魔
        "StoredEnchantments": [
          {
            "id": "minecraft:protection",
            "lvl": 6 // 保护 Ⅶ
          }
        ]
      }
    }
  });

  // 使用魔法仪式合成保护7
  e.custom({
    "type": "goety:ritual", // 仪式类型
    "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
    "activation_item": { // 激活仪式所需的物品 (中心物品)
      "item": "aquamirae:ship_graveyard_echo"// 使用海船墓地之回响作为激活物品
    },
    "craftType": "magic", // 制作类型，此处为魔法
    "soulCost": 400, // 仪式每秒消耗的灵魂点数 (示例值)
    "duration": 4, // 仪式持续时间，单位为刻度 (tick) (示例值，200 ticks = 10 秒)
    "ingredients": [ // 仪式所需材料 (围绕中心物品摆放)
      {
        "item": "l2complements:explosion_shard"//破灭残片
      },
      {
        "item": "l2complements:explosion_shard"//破灭残片
      },
      {
        "item": "l2complements:force_field" //守护力场
      },
      {
        "item": "l2complements:storm_core" //裂空结晶
      },
      {
        "item": "l2complements:storm_core" //裂空结晶
      },
      {
        "item": "hmag:multiplex_reinforcing_chain" //多重强化锁链
      },
      {
        "item": "bosses_of_mass_destruction:ancient_anima" //古代灵魂
      }
    ],
    "result": { // 仪式制作结果
      "item": "minecraft:enchanted_book",
      "nbt": { // 指定结果附魔书的附魔
        "StoredEnchantments": [
          {
            "id": "minecraft:protection",
            "lvl": 7 // 保护 Ⅶ
          }
        ]
      }
    }
  });

  // 使用魔法仪式合成保护8
  e.custom({
    "type": "goety:ritual", // 仪式类型
    "ritual_type": "goety:craft", // 仪式子类型，此处为制作仪式
    "activation_item": { // 激活仪式所需的物品 (中心物品)
      "item": "cataclysm:ignitium_ingot"// 使用滕炎锭作为激活物品
    },
    "craftType": "magic", // 制作类型，此处为魔法
    "soulCost": 800, // 仪式每秒消耗的灵魂点数 
    "duration": 4, // 仪式持续时间，单位为刻度 (tick) (示例值，200 ticks = 10 秒)
    "ingredients": [ // 仪式所需材料 (围绕中心物品摆放)
      {
        "item": "bosses_of_mass_destruction:obsidian_heart"//黑曜石之心
      },
      {
        "item": "mowziesmobs:wrought_helmet" //精炼头盔
      },
      {
        "item": "bosses_of_mass_destruction:void_thorn" // 虚空荆棘
      },
      {
        "item": "cataclysm:void_core" //虚空符文
      },
      {
        "item": "alexsmobs:void_worm_eye" //虚空蠕虫之眼
      },
      {
        "item": "bosses_of_mass_destruction:blazing_eye" //烈焰之眼
      }
    ],
    "result": { // 仪式制作结果
      "item": "minecraft:enchanted_book",
      "nbt": { // 指定结果附魔书的附魔
        "StoredEnchantments": [
          {
            "id": "minecraft:protection",
            "lvl": 8 // 保护 Ⅷ
          }
        ]
      }
    }
  });

  //死灵仪式召唤钢铁守护者
  e.custom({
    "type": "goety:ritual", // 仪式类型
    "ritual_type": "goety:summon", // 仪式子类型，此处为召唤仪式
    "activation_item": { // 激活仪式所需的物品 (中心物品)
      "item": "enigmaticlegacy:evil_essence"// 使用邪恶精粹作为激活物品
    },
    "craftType": "necroturgy", // 制作类型，此处为召唤
    "entity_to_summon": "mowziesmobs:ferrous_wroughtnaut",//召唤的生物为钢铁守护者
    "soulCost": 500, // 仪式每秒消耗的灵魂点数 (示例值)
    "duration": 4, // 仪式持续时间，单位为刻度 (tick) (示例值，200 ticks = 10 秒)
    "ingredients": [ // 仪式所需材料 (围绕中心物品摆放)
      {
        "item": "minecraft:iron_axe",  // 铁斧
      },
      {
        "item": "minecraft:iron_helmet",  // 铁头盔
      },
      {
        "item": "minecraft:iron_block" //铁块
      },
      {
        "item": "minecraft:iron_block" //铁块
      },
      {
        "item": "minecraft:iron_block" //铁块
      },
      {
        "item": "minecraft:iron_block" //铁块
      }
    ],
    "result": { // 仪式制作结果
      "item": "minecraft:egg" // 仪式完成后不会产出物品，仅用于 JEI 显示
    }
  });

  //死灵仪式召唤先驱者
  e.custom({
    "type": "goety:ritual", // 仪式类型
    "ritual_type": "goety:summon", // 仪式子类型，此处为召唤仪式
    "activation_item": { // 激活仪式所需的物品 (中心物品)
      "item": "cataclysm:mech_eye" // 使用机械之眼作为激活物品
    },
    "craftType": "necroturgy", // 制作类型，此处为召唤
    "entity_to_summon": "cataclysm:the_harbinger",//召唤的生物为先驱者
    "soulCost": 500, // 仪式每秒消耗的灵魂点数 (示例值)
    "duration": 4, // 仪式持续时间，单位为刻度 (tick) (示例值，200 ticks = 10 秒)
    "ingredients": [ // 仪式所需材料 (围绕中心物品摆放)
      {
        "item": "minecraft:nether_star" //下界之星
      },
      {
        "item": "minecraft:netherite_ingot" //下届合金锭
      },
      {
        "item": "minecraft:netherite_ingot" //下届合金锭
      },
      {
        "item": "enigmaticlegacy:evil_ingot" // 极恶锭
      },
      {
        "item": "enigmaticlegacy:evil_ingot" // 极恶锭
      },
      {
        "item": "minecraft:wither_skeleton_skull" // 凋灵骷髅头
      }
    ],
    "result": { // 仪式制作结果
      "item": "minecraft:egg" // 仪式完成后不会产出物品，仅用于 JEI 显示
    }
  });

  //死灵仪式召唤船长
  e.custom({
    "type": "goety:ritual", // 仪式类型
    "ritual_type": "goety:summon", // 仪式子类型，此处为召唤仪式
    "activation_item": { // 激活仪式所需的物品 (中心物品)
      "item": "enigmaticlegacy:evil_essence"// 使用邪恶精粹作为激活物品
    },
    "craftType": "necroturgy", // 制作类型，此处为召唤
    "entity_to_summon": "aquamirae:captain_cornelia",//召唤的生物为先驱者
    "soulCost": 500, // 仪式每秒消耗的灵魂点数 (示例值)
    "duration": 4, // 仪式持续时间，单位为刻度 (tick) (示例值，200 ticks = 10 秒)
    "ingredients": [ // 仪式所需材料 (围绕中心物品摆放)
      {
        "item": "minecraft:nether_star" //下界之星
      },
      {
        "item": "minecraft:nautilus_shell" //鹦鹉螺壳
      },
      {
        "item": "aquamirae:oxygen_tank" //氧气罐
      },
      {
        "item": "aquamirae:three_bolt_suit", // 潜水胸甲
      },
      {
        "item": "aquamirae:three_bolt_leggings", // 潜水裤子
      },
      {
        "item": "aquamirae:three_bolt_boots", // 潜水靴
      }
    ],
    "result": { // 仪式制作结果
      "item": "minecraft:egg" // 仪式完成后不会产出物品，仅用于 JEI 显示
    }
  });

  //死灵仪式召唤下界合金巨兽
  e.custom({
    "type": "goety:ritual", // 仪式类型
    "ritual_type": "goety:summon", // 仪式子类型，此处为召唤仪式
    "activation_item": { // 激活仪式所需的物品 (中心物品)
      "item": "enigmaticlegacy:evil_essence"// 使用邪恶精粹作为激活物品
    },
    "craftType": "necroturgy", // 制作类型，此处为召唤
    "entity_to_summon": "cataclysm:netherite_monstrosity",//召唤的生物为先驱者
    "soulCost": 500, // 仪式每秒消耗的灵魂点数 (示例值)
    "duration": 4, // 仪式持续时间，单位为刻度 (tick) (示例值，200 ticks = 10 秒)
    "ingredients": [ // 仪式所需材料 (围绕中心物品摆放)
      {
        "item": "minecraft:nether_star" //下界之星
      },
      {
        "item": "minecraft:iron_block" //铁块
      },
      {
        "item": "minecraft:iron_block" //铁块
      },
      {
        "item": "minecraft:iron_block" //铁块
      },
      {
        "item": "minecraft:magma_block", // 岩浆块
      },
      {
        "item": "hmag:netherite_scrap_block", // 下界合金碎片块
      },
      {
        "item": "hmag:netherite_scrap_block", // 下界合金碎片块
      },
      {
        "item": "minecraft:magma_block", // 岩浆块
      },
    ],
    "result": { // 仪式制作结果
      "item": "minecraft:egg" // 仪式完成后不会产出物品，仅用于 JEI 显示
    }
  });

  let create = e.recipes.create
  create.compacting(Item.of("minecraft:tuff", 8), ["create:limestone", "create:scoria"]).heated()
  create.compacting(Item.of("minecraft:tuff", 4), ["minecraft:quartz", "create:scoria"])
  create.milling(Item.of("minecraft:gunpowder").withChance(0.25), "minecraft:flint")
  create.cutting(Item.of("minecraft:netherite_scrap", 4), "minecraft:netherite_ingot").processingTime(20)
  create.cutting(Item.of("tacz:ammo", 64, "{AmmoId:'tacz:9mm'}"), "kubejs:package_9mm").processingTime(20)
  create.cutting(Item.of("tacz:ammo", 64, "{AmmoId:'tacz:12g'}"), "kubejs:package_12g").processingTime(20)
  create.cutting(Item.of("tacz:ammo", 64, "{AmmoId:'tacz:338'}"), "kubejs:package_3006").processingTime(20)
  create.cutting(Item.of("tacz:ammo", 64, "{AmmoId:'tacz:762x39'}"), "kubejs:package_76239").processingTime(20)
  create.cutting(Item.of("tacz:ammo", 64, "{AmmoId:'tacz:rpg_rocket'}"), "kubejs:package_rocket").processingTime(20)
  create.cutting(Item.of("tacz:ammo", 64, "{AmmoId:'lradd:arrow'}"), "kubejs:package_arrow").processingTime(20)
  create.cutting(Item.of("tacz:ammo", 15, "{AmmoId:'lradd:nail'}"), "minecraft:iron_nugget").processingTime(20)
  create.cutting(Item.of("tacz:ammo", 16, "{AmmoId:'trisdyna:emx_b1'}"), "kubejs:package_emx_b1").processingTime(20)
  e.shapeless(Item.of("tacz:ammo", 48, "{AmmoId:'tacz:9mm'}"), "kubejs:package_9mm")
  e.shapeless(Item.of("tacz:ammo", 48, "{AmmoId:'tacz:12g'}"), "kubejs:package_12g")
  e.shapeless(Item.of("tacz:ammo", 48, "{AmmoId:'tacz:338'}"), "kubejs:package_3006")
  e.shapeless(Item.of("tacz:ammo", 48, "{AmmoId:'tacz:762x39'}"), "kubejs:package_76239")
  e.shapeless(Item.of("tacz:ammo", 48, "{AmmoId:'tacz:rpg_rocket'}"), "kubejs:package_rocket")
  e.shapeless(Item.of("tacz:ammo", 48, "{AmmoId:'lradd:arrow'}"), "kubejs:package_arrow")
  e.shapeless(Item.of("tacz:ammo", 12, "{AmmoId:'trisdyna:emx_b1'}"), "kubejs:package_emx_b1")
  create.compacting("kubejs:package_9mm", ["create:brass_ingot", "create:brass_ingot", "minecraft:gunpowder"])

  let a12g = "kubejs:incomplete_12g";
  create.sequenced_assembly(
    Item.of("kubejs:package_12g"),
    "#forge:plates/iron",
    [
      create.deploying(a12g, [a12g, "#forge:ingots/brass"]),
      create.deploying(a12g, [a12g, "#forge:ingots/brass"]),
      create.deploying(a12g, [a12g, "minecraft:gunpowder"]),
      create.pressing(a12g, a12g),
      create.deploying(a12g, [a12g, "#forge:nuggets/iron"]),
      create.deploying(a12g, [a12g, "#forge:nuggets/iron"])
    ]
  )
    .transitionalItem(a12g)
    .loops(4)

  let a3006 = "kubejs:incomplete_3006";
  create.sequenced_assembly(
    Item.of("kubejs:package_3006"),
    "#forge:plates/gold",
    [
      create.deploying(a3006, [a3006, "#forge:storage_blocks/brass"]),
      create.pressing(a3006, a3006),
      create.deploying(a3006, [a3006, "minecraft:gunpowder"]),
      create.deploying(a3006, [a3006, "minecraft:gunpowder"]),
      create.deploying(a3006, [a3006, "minecraft:netherite_scrap"])
    ]
  )
    .transitionalItem(a3006)
    .loops(2)

  let arocket = "kubejs:incomplete_rocket";
  create.sequenced_assembly(
    Item.of("kubejs:package_rocket"),
    "#forge:plates/brass",
    [
      create.deploying(arocket, [arocket, "#forge:storage_blocks/brass"]),
      create.filling(arocket, [arocket, Fluid.of("minecraft:lava", 50)]),
      create.deploying(arocket, [arocket, "#forge:storage_blocks/iron"]),
      create.deploying(arocket, [arocket, "#forge:storage_blocks/iron"]),
      create.deploying(arocket, [arocket, "minecraft:blaze_powder"]),
      create.deploying(arocket, [arocket, "minecraft:netherite_scrap"])
    ]
  )
    .transitionalItem(arocket)
    .loops(2)

  let a76239 = "kubejs:incomplete_76239";
  create.sequenced_assembly(
    Item.of("kubejs:package_76239"),
    "#forge:plates/brass",
    [
      create.deploying(a76239, [a76239, "#forge:ingots/brass"]),
      create.deploying(a76239, [a76239, "#forge:ingots/brass"]),
      create.deploying(a76239, [a76239, "minecraft:gunpowder"])
    ]
  )
    .transitionalItem(a76239)
    .loops(4)

  let arrow = "kubejs:incomplete_arrow";
  create.sequenced_assembly(
    Item.of("kubejs:package_arrow"),
    "minecraft:amethyst_shard",
    [
      create.deploying(arrow, [arrow, "#forge:ingots/iron"]),
      create.deploying(arrow, [arrow, "minecraft:arrow"]),
      create.deploying(arrow, [arrow, "minecraft:arrow"]),
      create.deploying(arrow, [arrow, "minecraft:arrow"]),
      create.deploying(arrow, [arrow, "minecraft:amethyst_shard"])
    ]
  )
    .transitionalItem(arrow)
    .loops(4)

  let emx_b1 = "kubejs:incomplete_emx_b1";
  create.sequenced_assembly(
    Item.of("kubejs:package_emx_b1"),
    "#forge:plates/iron",
    [
      create.deploying(emx_b1, [emx_b1, "#forge:storage_blocks/gold"]),
      create.deploying(emx_b1, [emx_b1, "#forge:storage_blocks/gold"]),
      create.deploying(emx_b1, [emx_b1, "#forge:storage_blocks/iron"]),
      create.deploying(emx_b1, [emx_b1, "#forge:storage_blocks/iron"]),
      create.deploying(emx_b1, [emx_b1, "#forge:storage_blocks/redstone"]),
      create.deploying(emx_b1, [emx_b1, "#forge:storage_blocks/redstone"]),
      create.deploying(emx_b1, [emx_b1, "minecraft:netherite_scrap"])
    ]
  )
    .transitionalItem(emx_b1)
    .loops(2)
});
